/**
  ******************************************************************************
  * File Name          : FMC.c
  * Date               : 03/07/2014 08:46:19
  * Description        : This file provides code for the configuration
  *                      of the FMC peripheral.
  ******************************************************************************
  *
  * COPYRIGHT(c) 2014 STMicroelectronics
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */
/* Includes ------------------------------------------------------------------*/
#include "fmc.h"

#include "gpio.h"

//#include "compile.h"

/* USER CODE BEGIN 0 */

NOR_HandleTypeDef hnor1;
SRAM_HandleTypeDef hsram2;
SRAM_HandleTypeDef hsram3;
SDRAM_HandleTypeDef hsdram1;

void MX_FMC_SRAM1_Init(void);
void MX_FMC_SRAM2_Init(void);
void MX_FMC_NORFLASH_Init(void);
void MX_FMC_SDRAM_Init(void);

/* USER CODE END 0 */

/* FMC initialization function */
void MX_FMC_Init(void)
{
  __FMC_CLK_ENABLE();
  
  MX_FMC_SRAM1_Init();
  
  MX_FMC_SRAM2_Init();
  
  MX_FMC_NORFLASH_Init();
}

FMC_NORSRAM_TimingTypeDef Timing;

void MX_FMC_SRAM1_Init(void)
{
  /** Perform the SRAM2 memory initialization sequence
  */
  // taken from Eval Board BSP in STM32Cube_FW_F4_V1.11.0\Projects\STM324x9I_EVAL\Examples\FMC\FMC_SRAM\Src\main.c
  hsram2.Instance  = FMC_NORSRAM_DEVICE;
  hsram2.Extended  = FMC_NORSRAM_EXTENDED_DEVICE;
  
  Timing.AddressSetupTime       = 2;
  Timing.AddressHoldTime        = 1;
  Timing.DataSetupTime          = 2;
  Timing.BusTurnAroundDuration  = 1;
  Timing.CLKDivision            = 2;
  Timing.DataLatency            = 2;
  Timing.AccessMode             = FMC_ACCESS_MODE_A;
  
  hsram2.Init.NSBank             = FMC_NORSRAM_BANK2;
  hsram2.Init.DataAddressMux     = FMC_DATA_ADDRESS_MUX_DISABLE;
  hsram2.Init.MemoryType         = FMC_MEMORY_TYPE_SRAM;
  hsram2.Init.MemoryDataWidth    = FMC_NORSRAM_MEM_BUS_WIDTH_16;
  hsram2.Init.BurstAccessMode    = FMC_BURST_ACCESS_MODE_DISABLE;
  hsram2.Init.WaitSignalPolarity = FMC_WAIT_SIGNAL_POLARITY_LOW;
  hsram2.Init.WrapMode           = FMC_WRAP_MODE_DISABLE;
  hsram2.Init.WaitSignalActive   = FMC_WAIT_TIMING_BEFORE_WS;
  hsram2.Init.WriteOperation     = FMC_WRITE_OPERATION_ENABLE;
  hsram2.Init.WaitSignal         = FMC_WAIT_SIGNAL_DISABLE;
  hsram2.Init.ExtendedMode       = FMC_EXTENDED_MODE_DISABLE;
  hsram2.Init.AsynchronousWait   = FMC_ASYNCHRONOUS_WAIT_DISABLE;
  hsram2.Init.WriteBurst         = FMC_WRITE_BURST_DISABLE;
  hsram2.Init.ContinuousClock    = FMC_CONTINUOUS_CLOCK_SYNC_ASYNC;
  
  /* ExtTiming */

  HAL_SRAM_Init(&hsram2, &Timing, &Timing);
  HAL_SRAM_WriteOperation_Enable(&hsram2);
  if(HAL_SRAM_GetState(&hsram2) != HAL_SRAM_STATE_READY)
  {
  }
}

void MX_FMC_SRAM2_Init(void)
{
  /** Perform the SRAM3 memory initialization sequence
  */
  hsram3.Instance = FMC_NORSRAM_DEVICE;
  hsram3.Extended = FMC_NORSRAM_EXTENDED_DEVICE;
  /* hsram3.Init */
  hsram3.Init.NSBank = FMC_NORSRAM_BANK3;
  hsram3.Init.DataAddressMux = FMC_DATA_ADDRESS_MUX_DISABLE;
  hsram3.Init.MemoryType = FMC_MEMORY_TYPE_SRAM;
  hsram3.Init.MemoryDataWidth = FMC_NORSRAM_MEM_BUS_WIDTH_16;
  hsram3.Init.BurstAccessMode = FMC_BURST_ACCESS_MODE_DISABLE;
  hsram3.Init.WaitSignalPolarity = FMC_WAIT_SIGNAL_POLARITY_LOW;
  hsram3.Init.WrapMode = FMC_WRAP_MODE_DISABLE;
  hsram3.Init.WaitSignalActive = FMC_WAIT_TIMING_BEFORE_WS;
  hsram3.Init.WriteOperation = FMC_WRITE_OPERATION_ENABLE;
  hsram3.Init.WaitSignal = FMC_WAIT_SIGNAL_DISABLE;
  hsram3.Init.ExtendedMode = FMC_EXTENDED_MODE_DISABLE;
  hsram3.Init.AsynchronousWait = FMC_ASYNCHRONOUS_WAIT_DISABLE;
  hsram3.Init.WriteBurst = FMC_WRITE_BURST_DISABLE;
  hsram3.Init.ContinuousClock = FMC_CONTINUOUS_CLOCK_SYNC_ONLY;
  /* Timing */
  Timing.AddressSetupTime = 5;
  Timing.AddressHoldTime = 12;
  Timing.DataSetupTime = 100;
  Timing.BusTurnAroundDuration = 15;
  Timing.CLKDivision = 16;
  Timing.DataLatency = 17;
  Timing.AccessMode = FMC_ACCESS_MODE_A;
  /* ExtTiming */

  HAL_SRAM_Init(&hsram3, &Timing, &Timing);
  HAL_SRAM_WriteOperation_Enable(&hsram3);
  if(HAL_SRAM_GetState(&hsram3) != HAL_SRAM_STATE_READY)
  {
  }
}

void MX_FMC_NORFLASH_Init(void)
{
  FMC_NORSRAM_TimingTypeDef Timing;

  /** Perform the NOR1 memory initialization sequence
  */
  hnor1.Instance  = FMC_NORSRAM_DEVICE;
  hnor1.Extended  = FMC_NORSRAM_EXTENDED_DEVICE;

  /* NOR device configuration */  
  Timing.AddressSetupTime       = 4;//8;
  Timing.AddressHoldTime        = 3;
  Timing.DataSetupTime          = 7;//9;
  Timing.BusTurnAroundDuration  = 0;
  Timing.CLKDivision            = 2;
  Timing.DataLatency            = 1;
  Timing.AccessMode             = FMC_ACCESS_MODE_B;
  
  hnor1.Init.NSBank                 = FMC_NORSRAM_BANK1;
  hnor1.Init.DataAddressMux         = FMC_DATA_ADDRESS_MUX_DISABLE;
  hnor1.Init.MemoryType             = FMC_MEMORY_TYPE_NOR;
  hnor1.Init.MemoryDataWidth        = FMC_NORSRAM_MEM_BUS_WIDTH_16;
  hnor1.Init.BurstAccessMode        = FMC_BURST_ACCESS_MODE_DISABLE;
  hnor1.Init.WaitSignalPolarity     = FMC_WAIT_SIGNAL_POLARITY_LOW;
  hnor1.Init.WrapMode               = FMC_WRAP_MODE_DISABLE;
  hnor1.Init.WaitSignalActive       = FMC_WAIT_TIMING_BEFORE_WS;
  hnor1.Init.WriteOperation         = FMC_WRITE_OPERATION_ENABLE;
  hnor1.Init.WaitSignal             = FMC_WAIT_SIGNAL_DISABLE;
  hnor1.Init.ExtendedMode           = FMC_EXTENDED_MODE_DISABLE;
  hnor1.Init.AsynchronousWait       = FMC_ASYNCHRONOUS_WAIT_DISABLE;
  hnor1.Init.WriteBurst             = FMC_WRITE_BURST_DISABLE;
  
  HAL_NOR_Init(&hnor1, &Timing, NULL);
  HAL_NOR_WriteOperation_Enable(&hnor1);
  if(HAL_NOR_GetState(&hnor1) != HAL_NOR_STATE_READY)
  {
  }
}

static int FMC_Initialized = 0;
static int FMC_DeInitialized = 0;

static void HAL_FMC_MspInit(void){
  GPIO_InitTypeDef GPIO_InitStruct;
  if (FMC_Initialized) {
    return;
  }
  FMC_Initialized = 1;
  FMC_DeInitialized = 0;

  /* Peripheral clock enable */
  __FMC_CLK_ENABLE();
  
  /* GPIO clock enable */
  __GPIOD_CLK_ENABLE();
  __GPIOE_CLK_ENABLE();
  __GPIOF_CLK_ENABLE();
  __GPIOG_CLK_ENABLE();
  __GPIOH_CLK_ENABLE();
  __GPIOI_CLK_ENABLE();
  
  /** FMC GPIO Configuration  
  PD0   ------> FMC_D2
  PD1   ------> FMC_D3
  PD4   ------> FMC_NOE
  PD5   ------> FMC_NWE
  PD6   ------> FMC_NWAIT
  PD7   ------> FMC_NE1
  PD8   ------> FMC_D13
  PD9   ------> FMC_D14
  PD10   ------> FMC_D15
  PD11   ------> FMC_A16
  PD12   ------> FMC_A17
  PD13   ------> FMC_A18
  PD14   ------> FMC_D0
  PD15   ------> FMC_D1
  
  PE0   ------> FMC_NBL0
  PE1   ------> FMC_NBL1
  PE2   ------> FMC_A23
  PE3   ------> FMC_A19
  PE4   ------> FMC_A20
  PE5   ------> FMC_A21
  PE6   ------> FMC_A22
  PE7   ------> FMC_D4
  PE8   ------> FMC_D5
  PE9   ------> FMC_D6
  PE10   ------> FMC_D7
  PE11   ------> FMC_D8
  PE12   ------> FMC_D9
  PE13   ------> FMC_D10
  PE14   ------> FMC_D11
  PE15   ------> FMC_D12
  
  PF0   ------> FMC_A0
  PF1   ------> FMC_A1
  PF2   ------> FMC_A2
  PF3   ------> FMC_A3
  PF4   ------> FMC_A4
  PF5   ------> FMC_A5
  PF11   ------> FMC_SDNRAS
  PF12   ------> FMC_A6
  PF13   ------> FMC_A7
  PF14   ------> FMC_A8
  PF15   ------> FMC_A9
  
  PG0   ------> FMC_A10
  PG1   ------> FMC_A11
  PG2   ------> FMC_A12
  PG3   ------> FMC_A13
  PG4   ------> FMC_A14
  PG4   ------> FMC_BA0
  PG5   ------> FMC_A15
  PG8   ------> FMC_SDCLK
  PG9   ------> FMC_NE2
  PG10   ------> FMC_NE3
  PG15   ------> FMC_SDNCAS
  
  PH2   ------> FMC_SDCKE0
  PH3   ------> FMC_SDNE0
  PH5   ------> FMC_SDNWE
  PH8   ------> FMC_D16
  PH9   ------> FMC_D17
  PH10   ------> FMC_D18
  PH11   ------> FMC_D19
  PH12   ------> FMC_D20
  PH13   ------> FMC_D21
  PH14   ------> FMC_D22
  PH15   ------> FMC_D23
  
  PI0   ------> FMC_D24
  PI1   ------> FMC_D25
  PI2   ------> FMC_D26
  PI3   ------> FMC_D27
  PI4   ------> FMC_NBL2
  PI5   ------> FMC_NBL3
  PI6   ------> FMC_D28
  PI7   ------> FMC_D29
  PI9   ------> FMC_D30
  PI10   ------> FMC_D31
  
  */
  /* GPIO_InitStruct */
  GPIO_InitStruct.Pin = GPIO_PIN_7|GPIO_PIN_6|GPIO_PIN_0|GPIO_PIN_5 
                          |GPIO_PIN_1|GPIO_PIN_4|GPIO_PIN_15|GPIO_PIN_10 
                          |GPIO_PIN_14|GPIO_PIN_9|GPIO_PIN_8|GPIO_PIN_12 
                          |GPIO_PIN_13|GPIO_PIN_11;
  GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_HIGH;
  GPIO_InitStruct.Alternate = GPIO_AF12_FMC;

  HAL_GPIO_Init(GPIOD, &GPIO_InitStruct);

  /* GPIO_InitStruct */
  GPIO_InitStruct.Pin = GPIO_PIN_4|GPIO_PIN_3|GPIO_PIN_2|GPIO_PIN_1 
                          |GPIO_PIN_0|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_8 
                          |GPIO_PIN_9|GPIO_PIN_11|GPIO_PIN_14|GPIO_PIN_7 
                          |GPIO_PIN_10|GPIO_PIN_12|GPIO_PIN_15|GPIO_PIN_13;
  GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_HIGH;
  GPIO_InitStruct.Alternate = GPIO_AF12_FMC;

  HAL_GPIO_Init(GPIOE, &GPIO_InitStruct);

  /* GPIO_InitStruct */
  GPIO_InitStruct.Pin = GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3 
                          |GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_12|GPIO_PIN_15 
                          |GPIO_PIN_13|GPIO_PIN_14|GPIO_PIN_11;
  GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_HIGH;
  GPIO_InitStruct.Alternate = GPIO_AF12_FMC;

  HAL_GPIO_Init(GPIOF, &GPIO_InitStruct);

  /* GPIO_InitStruct */
  GPIO_InitStruct.Pin = GPIO_PIN_15|GPIO_PIN_10|GPIO_PIN_9|GPIO_PIN_8 
                          |GPIO_PIN_1|GPIO_PIN_3|GPIO_PIN_2|GPIO_PIN_0 
                          |GPIO_PIN_5|GPIO_PIN_4;
  GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_HIGH;
  GPIO_InitStruct.Alternate = GPIO_AF12_FMC;

  HAL_GPIO_Init(GPIOG, &GPIO_InitStruct);

  /* GPIO_InitStruct */
  GPIO_InitStruct.Pin = GPIO_PIN_15|GPIO_PIN_13|GPIO_PIN_14|GPIO_PIN_5 
                          |GPIO_PIN_3|GPIO_PIN_2|GPIO_PIN_12|GPIO_PIN_9 
                          |GPIO_PIN_11|GPIO_PIN_8|GPIO_PIN_10;
  GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_HIGH;
  GPIO_InitStruct.Alternate = GPIO_AF12_FMC;

  HAL_GPIO_Init(GPIOH, &GPIO_InitStruct);

  /* GPIO_InitStruct */
  GPIO_InitStruct.Pin = GPIO_PIN_4|GPIO_PIN_3|GPIO_PIN_2|GPIO_PIN_5 
                          |GPIO_PIN_7|GPIO_PIN_10|GPIO_PIN_6|GPIO_PIN_1 
                          |GPIO_PIN_9|GPIO_PIN_0;
  GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
  GPIO_InitStruct.Pull = GPIO_NOPULL;
  GPIO_InitStruct.Speed = GPIO_SPEED_HIGH;
  GPIO_InitStruct.Alternate = GPIO_AF12_FMC;

  HAL_GPIO_Init(GPIOI, &GPIO_InitStruct);

}

void HAL_NOR_MspInit(NOR_HandleTypeDef* hnor){
  HAL_FMC_MspInit();
}

void HAL_SRAM_MspInit(SRAM_HandleTypeDef* hsram){
  HAL_FMC_MspInit();
}

void HAL_SDRAM_MspInit(SDRAM_HandleTypeDef* hsdram){
  HAL_FMC_MspInit();
}

static void HAL_FMC_MspDeInit(void){
  if (FMC_DeInitialized) {
    return;
  }
  FMC_DeInitialized = 1;
  FMC_Initialized = 0;
  /* Peripheral clock enable */
  __FMC_CLK_DISABLE();
  
  /** FMC GPIO Configuration  
  PE4   ------> FMC_A20
  PE3   ------> FMC_A19
  PE2   ------> FMC_A23
  PE1   ------> FMC_NBL1
  PE0   ------> FMC_NBL0
  PD7   ------> FMC_NE1
  PE5   ------> FMC_A21
  PE6   ------> FMC_A22
  PG15   ------> FMC_SDNCAS
  PD6   ------> FMC_NWAIT
  PD0   ------> FMC_D2
  PI4   ------> FMC_NBL2
  PG10   ------> FMC_NE3
  PD5   ------> FMC_NWE
  PD1   ------> FMC_D3
  PI3   ------> FMC_D27
  PI2   ------> FMC_D26
  PF0   ------> FMC_A0
  PI5   ------> FMC_NBL3
  PI7   ------> FMC_D29
  PI10   ------> FMC_D31
  PI6   ------> FMC_D28
  PG9   ------> FMC_NE2
  PD4   ------> FMC_NOE
  PH15   ------> FMC_D23
  PI1   ------> FMC_D25
  PF1   ------> FMC_A1
  PI9   ------> FMC_D30
  PH13   ------> FMC_D21
  PH14   ------> FMC_D22
  PI0   ------> FMC_D24
  PF2   ------> FMC_A2
  PF3   ------> FMC_A3
  PG8   ------> FMC_SDCLK
  PF4   ------> FMC_A4
  PH5   ------> FMC_SDNWE
  PH3   ------> FMC_SDNE0
  PF5   ------> FMC_A5
  PH2   ------> FMC_SDCKE0
  PD15   ------> FMC_D1
  PD10   ------> FMC_D15
  PD14   ------> FMC_D0
  PD9   ------> FMC_D14
  PD8   ------> FMC_D13
  PF12   ------> FMC_A6
  PG1   ------> FMC_A11
  PF15   ------> FMC_A9
  PD12   ------> FMC_A17
  PD13   ------> FMC_A18
  PG3   ------> FMC_A13
  PG2   ------> FMC_A12
  PH12   ------> FMC_D20
  PF13   ------> FMC_A7
  PG0   ------> FMC_A10
  PE8   ------> FMC_D5
  PD11   ------> FMC_A16
  PG5   ------> FMC_A15
  PG4   ------> FMC_A14
  PG4   ------> FMC_BA0
  PH9   ------> FMC_D17
  PH11   ------> FMC_D19
  PF14   ------> FMC_A8
  PF11   ------> FMC_SDNRAS
  PE9   ------> FMC_D6
  PE11   ------> FMC_D8
  PE14   ------> FMC_D11
  PH8   ------> FMC_D16
  PH10   ------> FMC_D18
  PE7   ------> FMC_D4
  PE10   ------> FMC_D7
  PE12   ------> FMC_D9
  PE15   ------> FMC_D12
  PE13   ------> FMC_D10
  */

  HAL_GPIO_DeInit(GPIOE, GPIO_PIN_4|GPIO_PIN_3|GPIO_PIN_2|GPIO_PIN_1 
                          |GPIO_PIN_0|GPIO_PIN_5|GPIO_PIN_6|GPIO_PIN_8 
                          |GPIO_PIN_9|GPIO_PIN_11|GPIO_PIN_14|GPIO_PIN_7 
                          |GPIO_PIN_10|GPIO_PIN_12|GPIO_PIN_15|GPIO_PIN_13);

  HAL_GPIO_DeInit(GPIOD, GPIO_PIN_7|GPIO_PIN_6|GPIO_PIN_0|GPIO_PIN_5 
                          |GPIO_PIN_1|GPIO_PIN_4|GPIO_PIN_15|GPIO_PIN_10 
                          |GPIO_PIN_14|GPIO_PIN_9|GPIO_PIN_8|GPIO_PIN_12 
                          |GPIO_PIN_13|GPIO_PIN_11);

  HAL_GPIO_DeInit(GPIOG, GPIO_PIN_15|GPIO_PIN_10|GPIO_PIN_9|GPIO_PIN_8 
                          |GPIO_PIN_1|GPIO_PIN_3|GPIO_PIN_2|GPIO_PIN_0 
                          |GPIO_PIN_5|GPIO_PIN_4);

  HAL_GPIO_DeInit(GPIOI, GPIO_PIN_4|GPIO_PIN_3|GPIO_PIN_2|GPIO_PIN_5 
                          |GPIO_PIN_7|GPIO_PIN_10|GPIO_PIN_6|GPIO_PIN_1 
                          |GPIO_PIN_9|GPIO_PIN_0);

  HAL_GPIO_DeInit(GPIOF, GPIO_PIN_0|GPIO_PIN_1|GPIO_PIN_2|GPIO_PIN_3 
                          |GPIO_PIN_4|GPIO_PIN_5|GPIO_PIN_12|GPIO_PIN_15 
                          |GPIO_PIN_13|GPIO_PIN_14|GPIO_PIN_11);

  HAL_GPIO_DeInit(GPIOH, GPIO_PIN_15|GPIO_PIN_13|GPIO_PIN_14|GPIO_PIN_5 
                          |GPIO_PIN_3|GPIO_PIN_2|GPIO_PIN_12|GPIO_PIN_9 
                          |GPIO_PIN_11|GPIO_PIN_8|GPIO_PIN_10);

}

void HAL_NOR_MspDeInit(NOR_HandleTypeDef* hnor){
  HAL_FMC_MspDeInit();
}

void HAL_SRAM_MspDeInit(SRAM_HandleTypeDef* hsram){
  HAL_FMC_MspDeInit();
}

void HAL_SDRAM_MspDeInit(SDRAM_HandleTypeDef* hsdram){
  HAL_FMC_MspDeInit();
}
/**
  * @}
  */

/**
  * @}
  */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
